﻿// Please see documentation at https://learn.microsoft.com/aspnet/core/client-side/bundling-and-minification
// for details on configuring this project to bundle and minify static web assets.

// Write your JavaScript code.

function SidebarClickAsync() {
    var sidebar = document.querySelector('.sidebar');
    sidebar.classList.toggle('short');
}

function ToggleDropdown() {
    var popup = document.getElementById('userInfoPopup');
    popup.classList.remove('d-none');
    popup.classList.toggle('show');
}

function QickbarClickAsync() {
    var qickbar = document.querySelector('.qickbar');
    qickbar.classList.toggle('open');

    var headerright = document.querySelector('.header-right');
    headerright.classList.toggle('open');


}

function clearFilterForm() {
    const form = document.getElementById('filterForm');
    if (form) {
        //form.reset(); // Clear the input fields
        const inputs = form.elements;
        for (let i = 0; i < inputs.length; i++) {
            if (inputs[i].type === 'text') {
                inputs[i].value = '';
            }
        }
        form.submit(); // Submit the form
    }
}

window.onload = (event) => {
    const selectedRadio = document.querySelector('input[name="tab"]:checked');
    if (selectedRadio) {
        selectedRadio.onchange();  // Trigger the onchange event
    }
};

document.addEventListener('DOMContentLoaded', function () {
    // Get the breadcrumb container
    var breadcrumbContainer = document.querySelector('[data-breadcrumb-id]');
    if (breadcrumbContainer) {
        // Get the breadcrumb ID from the container's data attribute
        var breadcrumbId = breadcrumbContainer.getAttribute('data-breadcrumb-id');

        // Find the <a> element with the same data-slider-menu-id as breadcrumbId
        var sliderMenuItem = document.querySelector('a[data-slider-menu-id="' + breadcrumbId + '"]');
        if (sliderMenuItem) {
            // Perform desired actions on the found <a> element
            sliderMenuItem.classList.add('active'); // Example: Add an 'active' class
            // Call a function to find all parent nev-groups and extend/collapse them
            findAndHandleNevGroups(sliderMenuItem);

            // Ensure the active item is visible within its grandparent sidebar
            //scrollMenuItemIntoView(sliderMenuItem);
        }
    }


});

function findAndHandleNevGroups(element) {
    // Traverse up the DOM tree to find all parent nev-group elements
    var parentNevGroup = element.closest('.nev-group');
    while (parentNevGroup) {
        // Get the ID of the parent nev-group
        var nevGroupId = parentNevGroup.getAttribute('id');
        if (nevGroupId) {
            // Call the ExtendCollapse function with the nev-group ID
            ExtendCollapse(nevGroupId);
        }
        // Move to the next parent nev-group
        parentNevGroup = parentNevGroup.parentElement.closest('.nev-group');
    }
}

function scrollMenuItemIntoView(menuItem) {
    // Find the grandparent div with class 'sidebar'
    var sidebar = menuItem.closest('.sidebar');
    if (sidebar) {
        // Use scrollIntoView with options for smooth scrolling
        menuItem.scrollIntoView({
            behavior: 'smooth', // Smooth scrolling
            block: 'nearest',   // Scroll as little as possible to make the element visible
            inline: 'nearest'
        });
    }
}


function NavigateToBaseUrl() {
    window.location.href = '/';
}